function DRr_phibeta = getDRr_phibeta(HM,u,phi,FH)
% calculates induced resistance in [N]

MD=HM.MainDimensions;

%calculate Fn
Fn = u/(HM.gravity(1)*MD.Lwl(1))^0.5;
T = MD.Tc(1)+MD.bk(1);


%calculate effective draft
    TeCoeffs=[
    0   3.7455 -3.6246  0.0589 -0.0296	1.2306 -0.7256;...
    10	4.4892 -4.8454	0.0294 -0.0176  1.4231 -1.2971;...
    20	3.9592 -3.9804	0.0283 -0.0075	1.5450 -1.5622;...
    30	3.4891 -2.9577	0.0250 -0.0272	1.4744 -1.3499];

    %Spline Coefficients for current phi
    cTe=zeros(1,(size(TeCoeffs,2))-1);
    for n=2:(size(TeCoeffs,2))
    cTe(n-1) = interp1(TeCoeffs(1:end,1),TeCoeffs(1:end,n),phi,'spline');
    end
        
    Te=(cTe(1)*MD.Tc(1)/T+cTe(2)*(MD.Tc(1)/T)^2+...
        cTe(3)*MD.Bwl(1)/MD.Tc(1)+cTe(4)*MD.TRk(1))*(cTe(5)+...
        cTe(6)*Fn)*T;
    
%calculate resistance in [N]
DRr_phibeta=FH^2/(pi*Te^2*0.5*HM.rho(1)*u^2);

end
