function DRr_theta  = getDRr_theta(HM,Fn,phi,theta)
%calculates trimed resistance in [N]

MD=HM.MainDimensions;

R_thetaCoeffs=[
0     0        0        0        0        0        0;...
0.05  0        0        0        0        0        0;...
0.1   0        0        0        0        0        0;...
0.15  0        0        0        0        0        0;...
0.2   0        0        0        0        0        0;...
0.25  0.00191  0.00142  0.0036	-0.00396 -0.00035  0.00068;...
0.3	  0.0015   0.00085	0.0027	-0.003    0.00016  0.00001;...
0.35  0.00255  0.00266	0.00549	-0.00663  0.00037  0.00004;...
0.4	  0.00188  0.00291	0.00583	-0.00687  0.0011  -0.00031;...
0.45  0.00696  0.00334	0.00738	-0.00894  0.00165 -0.0005;...
0.5	  0.00628  0.0029	0.00721	-0.00802  0.00133 -0.00024;...
0.55  0.00262  0.00333	0.00736	-0.00756  0.00178 -0.00044;...
0.6	 -0.00458  0.0037	0.00723	-0.00654  0.00172 -0.00066];
    
%Spline Coefficients for current Fn
a=zeros(1,(size(R_thetaCoeffs,2))-1);
for n=2:(size(R_thetaCoeffs,2))
a(n-1) = interp1(R_thetaCoeffs(1:end,1),R_thetaCoeffs(1:end,n),Fn,'spline');
end
    
DRr_theta=(a(1)+a(2)*MD.Lwl(1)/MD.Bwl(1)+a(3)*MD.Bwl(1)/MD.Tc(1)+...
        a(4)*MD.Aw(1)/MD.Vc(1)^(2/3)+a(5)*(0.5-(MD.LCB(1)-MD.xFPP(1))/MD.Lwl(1))*100+...
        a(6)*(0.5-(MD.LCF(1)-MD.xFPP(1))/MD.Lwl(1))*100)*max(theta,0)*...
        HM.rho(1)*HM.gravity(1)*MD.Vc(1)*max(0,1-phi/10);
end
