function DRrh_phi = getDRrh_phi(HM,Fn,phi)
%calculates delta resiuary resistance of hull due to heel in [N]. includes
%estimation method if data of the heeled hull is not available.

MD=HM.MainDimensions;

%check wether data of the heeled hull is available 
if MD.heel_data == true
    %calculate current main dimensions
    currBwl= interp1(MD.Bwl_phi(1,1:end),MD.Bwl_phi(2,1:end),phi,'spline');
    currTc = interp1(MD.Tc_phi(1,1:end),MD.Tc_phi(2,1:end),phi,'spline');
    currCm = interp1(MD.Ax_phi(1,1:end),MD.Ax_phi(2,1:end),phi,'spline')/(currTc*currBwl);
    currLwl= interp1(MD.Lwl_phi(1,1:end),MD.Lwl_phi(2,1:end),phi,'spline');

    DRrh_phiCoeffs=[...
    0	   0.000  0.000	 0.000   0.000;...
    0.15  -1.850 -0.032	 1.037	 1.781;...
    0.2	  -1.032  0.000	 0.731	 0.996;...
    0.25   2.061 -0.024	 0.451  -2.046;...
    0.3	  10.881 -0.163	-0.431 -10.773;...
    0.35  26.984 -0.494	-2.208 -26.780;...
    0.4	  48.633 -1.062	-4.344 -48.397;...
    0.45  73.015 -1.795	-6.432 -72.799;...
    0.65  73.015 -1.795	-6.432 -72.799];

    %Spline Coefficients for current Fn
    a=zeros(1,(size(DRrh_phiCoeffs,2))-1);
    for n=2:(size(DRrh_phiCoeffs,2))
    a(n-1) = interp1(DRrh_phiCoeffs(1:end,1),DRrh_phiCoeffs(1:end,n),Fn,'pchip',DRrh_phiCoeffs( size(DRrh_phiCoeffs,1) ,n));
    end

    Cm = MD.Ax(1)/(MD.Tc(1)*MD.Bwl(1));
    DRrh_phi=(a(1)+a(2)*(currBwl/currTc-MD.Bwl(1)/MD.Tc(1))+a(3)*(currCm-Cm)+...
             a(4)*currLwl/MD.Lwl(1))*0.001*HM.rho*HM.gravity*MD.Vc(1);
else
    LCBpercent=(0.5-(MD.LCB(1)-MD.xFPP(1))/MD.Lwl(1))*100;

    DRrh_phiCoeffs=[...
    0.00   0.0000	 0.0000	 0.0000	0.0000	 0.0000	 0.0000;...
    0.25  -0.0268	-0.0014	-0.0057	0.0016	-0.0070	-0.0017;...
    0.30   0.6628	-0.0632	-0.0699	0.0069	 0.0459	-0.0004;...
    0.35   1.6433	-0.2144	-0.1640	0.0199	-0.0540	-0.0268;...
    0.40  -0.8659	-0.0354	 0.2226	0.0188	-0.5800	-0.1133;...
    0.45  -3.2715	 0.1372	 0.5547	0.0268	-1.0064	-0.2026;...
    0.50  -0.1976	-0.1480	-0.6593	0.1862	-0.7489	-0.1648;...
    0.55   1.5873	-0.3749	-0.7105	0.2146	-0.4818	-0.1174];

    %Spline Coefficients for current Fn
    a=zeros(1,(size(DRrh_phiCoeffs,2))-1);
    for n=2:(size(DRrh_phiCoeffs,2))
        a(n-1) = interp1(DRrh_phiCoeffs(1:end,1),DRrh_phiCoeffs(1:end,n),Fn,'pchip',DRrh_phiCoeffs( size(DRrh_phiCoeffs,1) ,n));
    end
    
    %calculate resistance for phi=20
    DRrh_phi20=(a(1) + a(2)*MD.Lwl(1)/MD.Bwl(1) + a(3)*MD.Bwl(1)/MD.Tc(1)...
               + a(4)*(MD.Bwl(1)/MD.Tc(1))^2 + a(5)*LCBpercent + a(6)*LCBpercent^2)...
               *MD.Vc(1) * HM.rho * HM.gravity * 1/1000;

    %calculate resistance for current heel
    DRrh_phi=DRrh_phi20*6*deg2rad(phi)^1.7; 
end


end
