function MZM_phi = getMZM_phi(HM, u, phi, beta)
%calculates Munk-moment and it's change due to heel in [Nm]
MD=HM.MainDimensions;

%calculate current C_form
currC_form= interp1(MD.C_form(1,1:end),MD.C_form(2,1:end),phi,'spline');

%calculate coefficient for delta MZM due to heel
cMZ0_phi=( 0.01 * MD.Bwl(1)^2 /( MD.Lwl(1) * MD.Tc(1) ) )/ 20 * phi;

%calculate delta MZM due to heel
MZ0=cMZ0_phi*0.5*HM.rho*u^2*MD.Lwl(1)*MD.Alat;

%calculate Munk-moment
MZM_phi=-(pi*HM.rho*u^2*deg2rad(beta)*currC_form + MZ0);

end
