function Rrh = getRrh(HM,Fn)
%calculates residuary resistance of hull in [N]
% Ref
% A BARE HULL RESISTANCE PREDICTION METHOD DERIVED FROM THE RESULTS OF THE DELFT SYSTEMATIC YACHT HULL SERIES EXTENDED TO HIGHER SPEEDS
% InnovSail 2008 

    MD=HM.MainDimensions;

    %Polynomial coefficients
    RrhCoeffs=[...
    0.00	 0.0000  0.0000  0.0000  0.0000	 0.0000	 0.0000	 0.0000	 0.0000;...
    0.15	-0.0005  0.0023 -0.0086 -0.0015  0.0061  0.0010  0.0001  0.0052;...
    0.20	-0.0003	 0.0059	-0.0064	 0.0070	 0.0014  0.0013	 0.0005	-0.0020;...
    0.25	-0.0002	-0.0156	 0.0031	-0.0021	-0.0070	 0.0148	 0.0010	-0.0043;...
    0.30	-0.0009	 0.0016	 0.0337	-0.0285	-0.0367	 0.0218	 0.0015	-0.0172;...
    0.35	-0.0026	-0.0567	 0.0446	-0.1091	-0.0707	 0.0914	 0.0021	-0.0078;...
    0.40	-0.0064	-0.4034	-0.1250	 0.0273	-0.1341	 0.3578	 0.0045	 0.1115;...
    0.45	-0.0218	-0.5261	-0.2945	 0.2485	-0.2428	 0.6293	 0.0081	 0.2086;...
    0.50	-0.0388	-0.5986	-0.3038	 0.6033	-0.0430	 0.8332	 0.0106	 0.1336;...
    0.55	-0.0347	-0.4764	-0.2361	 0.8726	 0.4219	 0.8990	 0.0096	-0.2272;...
    0.60	-0.0361	 0.0037	-0.2960	 0.9661	 0.6123	 0.7534	 0.0100	-0.3352;...
    0.65     0.0008	 0.3728	-0.3667	 1.3957	 1.0343	 0.3230	 0.0072	-0.4632;...
    0.70	 0.0108	-0.1238	-0.2026	 1.1282	 1.1836	 0.4973	 0.0038	-0.4477;...
    0.75	 0.1023	 0.7726	 0.5040	 1.7867	 2.1934	-1.5479	-0.0115	-0.0977];

    %Spline Coeffs for current Fn
    cRrh=zeros(1,(size(RrhCoeffs,2))-1);
    for n=2:(size(RrhCoeffs,2))
    cRrh(n-1) = interp1(RrhCoeffs(1:end,1),RrhCoeffs(1:end,n),Fn,'spline');
    end

    %calculate resistance in [N]
    Cp = MD.Vc(1)/(MD.Ax(1)*MD.Lwl(1));
    Cm = MD.Ax(1)/(MD.Tc(1)*MD.Bwl(1));
    Rrh=(cRrh(1)+(cRrh(2)*(MD.LCB(1)-MD.xFPP(1))/MD.Lwl(1)+cRrh(3)*Cp+cRrh(4)*MD.Vc(1)^(2/3)/MD.Aw(1)+...
    cRrh(5)*MD.Bwl(1)/MD.Lwl(1)+cRrh(6)*(MD.LCB(1)-MD.xFPP(1))/(MD.LCF(1)-MD.xFPP(1))+cRrh(7)*MD.Bwl(1)/MD.Tc(1)+...
    cRrh(8)*Cm)*MD.Vc(1)^(1/3)/MD.Lwl(1))*MD.Vc(1)*HM.rho(1)*HM.gravity(1);

end