function Rrk = getRrk(HM,Fn)
%calculates keel residuary resistance in [N]
MD=HM.MainDimensions;

RrkCoeffs=[...
0       0       0        0        0;...
0.2    -0.00104	0.00172  0.00117 -0.00008;...
0.25   -0.00550	0.00597  0.00390 -0.00009;...
0.3    -0.01110	0.01421  0.00069  0.00021;...
0.35   -0.00713	0.02632	-0.00232  0.00039;...
0.4    -0.03581	0.08649  0.00999  0.00017;...
0.45   -0.00470	0.11592	-0.00064  0.00035;...
0.5     0.00553	0.07371  0.05991 -0.00114;...
0.55	0.04822	0.00660  0.07048 -0.00035;...
0.6     0.01021	0.14173  0.06409 -0.00192;...
0.8     0.01021	0.14173  0.06409 -0.00192];

%Spline Coefficients for current Fn
cRrk=zeros(1,(size(RrkCoeffs,2))-1);
for n=2:(size(RrkCoeffs,2))
cRrk(n-1) = interp1(RrkCoeffs(1:end,1),RrkCoeffs(1:end,n),Fn,'pchip',RrkCoeffs( size(RrkCoeffs,1) ,n));
end

%calculate resistance in [N]
T = MD.Tc(1)+MD.bk(1);
Rrk=(cRrk(1)+cRrk(2)*T/MD.Bwl(1)+cRrk(3)*(MD.Tc(1)+...
abs(MD.Zcbk(1)))/MD.Vk(1)^(1/3)+cRrk(4)*MD.Vc(1)/MD.Vk(1))...
*MD.Vk(1)*HM.rho(1)*HM.gravity(1);

end
