function Rvr = getRvr(HM,u)
%calculates viscos resistance of rudder in [N]
MD=HM.MainDimensions;

%approximate form factor
cform_r=(1+2*MD.TCRr(1)+60*MD.TCRr(1)^4);
%calculate keel Rn
Rn_r=u*MD.cr(1)/HM.nu_kin(1);
%calculate resistance in [N]
Rvr=((0.075/(log10(Rn_r)-2)^2)*0.5*HM.rho(1)*u^2*MD.Sr(1))*cform_r;

end
