classdef CHelperFct < handle
    %UNTITLED Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        % rotation anonymous function handles
        % rotx = @(angle) [1 0 0; 0 cosd(angle) -sind(angle); 0 sind(angle) cosd(angle)];
        %roty = @(angle) [cosd(angle) 0 sind(angle); 0 1 0; -sind(angle) 0 cosd(angle)];
        %rotz = @(angle) [cosd(angle) -sind(angle) 0; sind(angle) cosd(angle) 0; 0 0 1];
    end
    
    
    methods(Static)
        %% fct to get values from a structure with a default return if field does not exist
        function val = getFromStruct(theStruct, fieldName, default)
            if isfield(theStruct, fieldName)
                val = theStruct.(fieldName);
                
            else
                val = default;
                s = append(fieldName, ": Wrong field name, default is taken");
                msgbox(s)
            end
        end %fct getFromStruct
        
        %% fcts return transformation matrix
        function tm = rotx(angle)
            tm = [1 0 0; 0 cosd(angle) -sind(angle); 0 sind(angle) cosd(angle)];
        end
        function tm = roty(angle)
            tm = [cosd(angle) 0 sind(angle); 0 1 0; -sind(angle) 0 cosd(angle)];
        end
        function tm = rotz(angle)
            tm = [cosd(angle) -sind(angle) 0; sind(angle) cosd(angle) 0; 0 0 1];
        end
        
        %% prepare a polar diagram for VPP results
        function axes1 = preparePolar(radii, majorTick, minorTick, axesLabel, figure1)
            %UNTITLED2 Summary of this function goes here
            %   Detailed explanation goes here
            
            angle = 0:5:180;

            % Create axes
            axes1 = axes('Parent', figure1, 'DataAspectRatio', [1 1 1]);
            axes1.XAxisLocation = 'origin';
            
            hold(axes1, 'on');
            
            
            for i = 1:size(radii, 2)
                x = sind(angle) * radii(i);
                y = cosd(angle) * radii(i);
                % Create plot
                plot(axes1,x, y, 'Color', [0 0 0], 'HandleVisibility','off');
            end
            
            maxRadius = max(radii);
            minRadius = min(radii);
            xlim(axes1,[0 maxRadius]);
            ylim(axes1,[-maxRadius maxRadius]);
            
            for i = 0:minorTick:180
                x = [sind(i)*minRadius sind(i)*maxRadius];
                y = [cosd(i)*minRadius cosd(i)*maxRadius];
                plot(axes1, x, y, 'LineStyle', ':', 'Color', [0 0 0], 'HandleVisibility','off');
            end
            
            for i = 0:majorTick:180
                x = [sind(i)*minRadius sind(i)*maxRadius];
                y = [cosd(i)*minRadius cosd(i)*maxRadius];
                plot(axes1, x, y, 'Color', [0 0 0], 'HandleVisibility','off');
            end
            
            % Create ylabel
            ylabel(axes1, axesLabel);
            
        end   % prepare polar
        
        %% prepare cartesian diagram for general use
        function prepareDiagram(xLabel, yLabel,varargin)
            % Create figure and axes
            figure('Color',[1 1 1]);
            axes('Color',[0.95 0.95 0.95]);
            hold('on');
            box('on');
            set(gca,'XGrid','on','YGrid','on','YColor',[0 0 0]);
            
            % Create xlabel
            xlabel(xLabel, 'Color', [0 0 0]);
            
            if nargin == 3
                yyaxis right;
                set(gca,'YColor',[0 0 0]);
                ylabel(varargin(1), 'Color', [0 0 0]);
                
                yyaxis left;
            end
            
            set(gca,'YColor',[0 0 0]);
            ylabel(yLabel, 'Color', [0 0 0]);
            
            % plot the legend
            legend(gca,'show','Color', [1 1 1], 'Interpreter', 'none');
            
            
        end % prepareDiagram
        
        %% function to delete comments in a commented json file
        function parsedString = removeJSONComments(subjectString)
            % Removes comments from a JSON-C string and returns a valid JSON string
            % Valid comments are:
            %  - One-line comments: // ....
            %  - Multi-line comments: /* ... */
            %  - Comment delimiters are ignored if they are inside "" strings
            % This function uses a regular expression to remove the comments,
            %   see documentation on MATLAB-style regular expressions.
            % This regexp matches strings delimited by " as well as comments
            % This is to ensure that we don't match // and /**/ delimiters inside strings
            pattern = '("[^"]*?")|(/\*.+?\*/)|(//.+?$)';
            [match,noMatch] = regexp(subjectString, pattern, 'match', 'split', 'lineanchors');
            % Iterate though the matches and only remove the ones that are not strings
            for k = 1:length(match)
                if not(startsWith(match{k}, '"'))
                    match{k} = '';
                end
            end
            % Reassemble the result
            parsedString = strjoin(noMatch, match);
        end % removeJSONComments()

        
    end % methods
end