function DRrk_phi = getDRrk_phi(HM,Fn,phi)
%%calculates delta residuary resistance keel due to heel in [N]
MD=HM.MainDimensions;

a=[-3.5837 -0.0518 0.5958 0.2055];
T = MD.Tc(1)+MD.bk(1);
ch=a(1)*MD.Tc(1)/T+a(2)*MD.Bwl(1)/MD.Tc(1)+...
   a(3)*MD.Bwl(1)/T+...
   a(4)*MD.Lwl(1)/MD.Vc(1)^(1/3);
    
DRrk_phi = ch*Fn^2*deg2rad(phi)*MD.Vk(1)*HM.rho(1)*HM.gravity(1);


end
