function FHs = getFHs(HM, u, phi, beta, delta)
    %calculates keel heeling force in [N]
    
    MD = HM.MainDimensions;
    
    %calculate effective aspect ratio keel
    ARek = 2 * MD.bk(1) / MD.ck(1);
    
    %calculate effective aspect ratio rudder
    ARer = 2 * MD.br(1) / MD.cr(1);
    
    %approximate lift curve slope per 
    a_0 = 0.9 * 2 * pi / 57.3; %corrected section lift curve slope
    
    %keel
    dCL_dbetak = a_0 * ARek /( cosd(MD.Lambda_k(1)) * (( ARek^2 / (cosd(MD.Lambda_k(1)))^4) +4 )^0.5 +...
        57.3 * a_0 / pi);
    
    %rudder
    dCL_dbetar = a_0 * ARer /( cosd(MD.Lambda_r(1)) * (( ARer^2 / (cosd(MD.Lambda_r(1)))^4) +4 )^0.5 +...
        57.3 * a_0 / pi);
    
    %calculate lift carry over coefficient
    cHull = 1.8 * MD.Tc(1)/MD.bk(1)+1;
    
    %calculate lift reduction coefficient due to heel
    cHeel = 1 - 0.382 * deg2rad(phi);
    
    %approximate zero lift drift angle []
    beta_0 = (0.405 * MD.Bwl(1) / MD.Tc(1) * deg2rad(phi))^2;
    
    %approximate downwash angle at rudder in []
    beta_down = rad2deg( (0.136 + 1/15000 * phi)*( abs(dCL_dbetak * (beta - beta_0) )/ ARek )^0.5 );
    
    %calculate keel heeling force in [N]
    FHs.FHk =(dCL_dbetak * (beta - beta_0) * 0.5 * HM.rho * u^2 * MD.Ak(1)) * cHull * cHeel;
    
    %calculate rudder heeling force in [N]
    FHs.FHr =(dCL_dbetar * (beta + delta - beta_0 - beta_down) * 0.5 * HM.rho * (0.9 * u)^2 * MD.Ar(1)) * cHull * cHeel;
    
end
