function RM = getRM(HM,phi)
%calculates hydrostatic righting moment in [Nm]

%calculate current righting arm
currhz= interp1(HM.MainDimensions.hz(1,1:end),HM.MainDimensions.hz(2,1:end),phi,'spline');

%calculate righting moment around longitudinal axis of boat, negative when righting
RM = -currhz*HM.MainDimensions.Vc(1)*HM.rho*HM.gravity; 

end