function  Rfh_phi = getRfh_phi(HM,u,phi)
%calculates frictional resistance of Hull. Includes an estimation method
%for the hulls wetted surface when heeled.

MD=HM.MainDimensions;

%check wether wetted surface data under heel is available
if MD.heel_data==true
    %calculate current wettet surface from table data
    currSc= interp1(MD.Sc_phi(1,1:end),MD.Sc_phi(2,1:end),phi,'spline');
else
    %estimate current wetted surface
    
    Sc_phiCoeffs= [0	 0       0       0  	0;
                   5  -4.112	 0.054	-0.027	6.329;
                  10  -4.522	-0.132	-0.077	8.738;
                  15  -3.291	-0.389	-0.118	8.949;
                  20   1.850	-1.200	-0.109	5.364;
                  25   6.510	-2.305	-0.066	3.443;
                  30  12.334	-3.911	 0.024	1.767;
                  35  14.648	-5.182	 0.102	3.497];
              
    %Spline Coefficients for current heel
    a=zeros(1,(size(Sc_phiCoeffs,2))-1);
    for n=2:(size(Sc_phiCoeffs,2))
    a(n-1) = interp1(Sc_phiCoeffs(1:end,1),Sc_phiCoeffs(1:end,n),phi,'pchip',Sc_phiCoeffs( size(Sc_phiCoeffs,1) ,n));
    end
    
    currSc = MD.Sc(1)*(1 + 0.01*(a(1) + a(2)*(MD.Bwl(1)/MD.Tc(1)) + a(3)*(MD.Bwl(1)/MD.Tc(1))^2+a(4)*MD.Cm(1)));
end

%calculate Rn
Rn = u*MD.Lwl(1)*MD.Lrefratio(1)/HM.nu_kin(1);

%calculate frictional resistance in [N]   %heel!!!!
Rfh_phi=(0.075/(log10(Rn)-2)^2)*0.5*HM.rho(1)*u^2*currSc;

end