function Rvk = getRvk(HM,u)
%calculates viscos resistance of keel in [N]

MD=HM.MainDimensions;

%approximate form factor
cform_k=(1+2*MD.TCRk(1)+60*MD.TCRk(1)^4);
%calculate keel Rn
Rn_k=u*MD.ck(1)/HM.nu_kin(1);
%calculate resistance in [N]
Rvk=((0.075/(log10(Rn_k)-2)^2)*0.5*HM.rho(1)*u^2*MD.Sk(1))*cform_k;

end
