classdef CHull
	%simple class to get hull resistance depending on velocity and lcg
	%   Detailed explanation goes here
	
	properties
        %%
		density = 1000;
        
        % standardvalues

        maxCrewRightingMoment = 1.5 * 124 * 9.8065 + 4.5;  % TODO do not really know the crew lever
        VCE = 0.4;   % assumption, VCE 0.4 m below waterplane
		
        % members for resistance response surface, no leeway
        u = [0; 1; 2; 3; 4];
        res = [0; 11; 39; 135; 259] * 2;     % TODO resistance not correct        
        resInterpolant;
               
        % coefficients for linear side lift gradient
        dLdLW = 101.68;
        L0 = 0;   %  TODO  100 for asymm, 0 for sym
        
        % effective draft Te
        Te = 1.3327 * 0.666;    % TODO 1.3327 is the result of lifting line method with fully immersed centerboard under flat plate
                                % 0.66666 is correction for free water plane and the fact that hull and rudder have much lower Te
                                % 1.2979 is the efffective span for the asymmetric centerboard
               
        
        rotz = @(yawAngle) [cosd(yawAngle) sind(yawAngle) 0; -sind(yawAngle) cosd(yawAngle) 0; 0 0 1];
		
	end %properties
	
	methods
		%% CHull Construct an instance of this class, generates interpolater classes for RT=f(velo, buoy) and buoy=f(fly)
		function obj = CHull
            % hull resistance using spline object
			obj.resInterpolant = griddedInterpolant(obj.u,obj.res, 'pchip');     
		end
		
		%% get flow forces for appended hull
		function F = getForces(obj,velo,leeway)
           
            
            % calculate upright resistance for m=168kg
            F(1) = obj.resInterpolant(velo);
          
            % calculate side lift
            L = obj.dLdLW * leeway + obj.L0;
            L = L / 0.7;    % assuming that hull and rudder produce 30% of side force
            F(2) = L;
            F(4) = -L * obj.VCE;
            
            % calculate induced and profile parasitic drag

            Ri = L^2/obj.Te^2 / (0.5 * obj.density * velo^2 * pi);
            
            F(1) = F(1) + Ri;
            
            % vertical force is ballanced by weight
            F(3) = 0;
            F(5) = 0;
            F(6) = 0;
            
            F = F.';
            
            F(1:3) = obj.rotz(-leeway) * F(1:3);
            F(4:6) = obj.rotz(-leeway) * F(4:6);
            
            
        end
	end % methods
end

