function preparePolar(radii, majorTick, minorTick, axesLabel)
    %UNTITLED2 Summary of this function goes here
    %   Detailed explanation goes here

    angle = 0:5:90;

    % Create figure
    figure1 = figure;

    % Create axes
    axes1 = axes('Parent', figure1, 'DataAspectRatio', [1 1 1]);
    axes1.XAxisLocation = 'origin';

    %box(axes1,'on');
    hold(axes1, 'all');


    for i = 1:size(radii, 2)
        x = sind(angle) * radii(i);
        y = cosd(angle) * radii(i);
        % Create plot
        plot(x, y, 'Color', [0 0 0], 'HandleVisibility','off');
        hold('on');
    end

    maxRadius = max(radii);
    minRadius = min(radii);

    for i = 0:minorTick:90
        x = [sind(i)*minRadius sind(i)*maxRadius];
        y = [cosd(i)*minRadius cosd(i)*maxRadius];
        plot(x, y, 'LineStyle', ':', 'Color', [0 0 0], 'HandleVisibility','off');
        hold('on');
    end

    for i = 0:majorTick:90
        x = [sind(i)*minRadius sind(i)*maxRadius];
        y = [cosd(i)*minRadius cosd(i)*maxRadius];
        plot(x, y, 'Color', [0 0 0], 'HandleVisibility','off');
        hold('on');
    end

    % Create title
    %title('Velocity Polar');

    % Create ylabel
    ylabel(axesLabel);

end
